﻿<%@ Import Namespace="System.Xml.Serialization" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>Dokument dostawy</title>
        <script runat="server">

            public enum JednostkaKg
            {
                [Caption("kg")]
                kg1,
                [Caption("1000 kg")]
                kg1000
            }

            public class PrnParams : SerializableContextBase
            {
                public PrnParams(Context context)
                    : base(context)
                {
                    DokumentHandlowy dokument = Dokument;
                    if (dokument != null)
                    {
                        if (dokument.Kontrahent != null)
                          this.podstawaZwolnienia = (string) dokument.Kontrahent.Features["Podstawa zwolnienia z akcyzy"];

                        if (dokument.Magazyn != null && dokument.Magazyn.Oddzial != null)
                            miejsceWysyłki = dokument.Magazyn.Oddzial.Adres.Pełny;
                        else
                            miejsceWysyłki = Soneta.Core.CoreModule.GetInstance(this).Config.Firma.Pieczątka.GetPieczątka(dokument.Data).Adres.ToString();

                        if (dokument.OdbiorcaMiejsceDostawy != null)
                            miejsceOdbioru = dokument.OdbiorcaMiejsceDostawy.Adres.Pełny;
                        else
                            miejsceOdbioru = dokument.DaneKontrahenta.Adres.Pełny;
                    }
                }

                private int iloscKopii = 4;
                private string podstawaZwolnienia;
                private string miejsceWysyłki;
                private string miejsceOdbioru;
                private Date dataOdbioru = Date.Today;

                [Priority(10)]
                public int IlośćKopii
                {
                    get { return iloscKopii; }
                    set { iloscKopii = value; }
                }

                [Priority(15)]
                [Caption("Data odbioru")]
                [XmlIgnore]
                public Date DataOdbioru
                {
                    get { return dataOdbioru; }
                    set { dataOdbioru = value; }
                }

                [Priority(20)]
                [XmlIgnore]
                public string PodstawaZwolnienia
                {
                    get { return podstawaZwolnienia; }
                    set { podstawaZwolnienia = value; }
                }

                [Priority(30)]
                [XmlIgnore]
                public string MiejsceWysyłki
                {
                    get { return miejsceWysyłki; }
                    set { miejsceWysyłki = value; }
                }

                [Priority(40)]
                [XmlIgnore]
                public string MiejsceOdbioru
                {
                    get { return miejsceOdbioru; }
                    set { miejsceOdbioru = value; }
                }

                [Priority(50)]
                public string NrAkcyzowy { get; set; }

                [Priority(60)]
                [XmlIgnore]
                public string NrAkcyzowyPodmiotu { get; set; }

                [Priority(70)]
                public JednostkaKg Jednostka { get; set; }

                DokumentHandlowy Dokument
                {
                    get { return (DokumentHandlowy) this.Context[typeof (DokumentHandlowy)]; }
                }

                public ArrayList GetDokumenty()
                {
                    ArrayList l = new ArrayList();
                    for (int i = 1; i <= iloscKopii; i++)
                        l.Add(Dokument);
                    return l;
                }

                public DokumentHandlowy GetDokument()
                {
                    return Dokument;
                }
            }

            PrnParams pars = null;
            [Context(Required = true)]
            public PrnParams Params
            {
                get { return pars; }
                set { pars = value; }
            }

       
            void OnContextLoad(Object sender, EventArgs args)
            {
                DataRepeater1.DataSource = pars.GetDokumenty();
                DokumentHandlowy dok = pars.GetDokument();
                Soneta.Core.IPieczątkaFirmy pieczatka = Soneta.Core.CoreModule.GetInstance(dok).Config.Firma.Pieczątka.GetPieczątka(dok.Data);

                labelNazwaFirmy.EditValue = pieczatka.Nazwa;

                labelNrAkcyzowy.EditValue = pars.NrAkcyzowy;
                labelNrAkcyzowyPodmiotu.EditValue = pars.NrAkcyzowyPodmiotu;

                labelAdresSiedziby1.EditValue = pieczatka.Adres.Linia1;
                labelAdresSiedziby2.EditValue = pieczatka.Adres.Linia2;

                labelAdresWysylki.EditValue = pars.MiejsceWysyłki;
                labelAdresOdbioru.EditValue = pars.MiejsceOdbioru;

                labelDataWysylki.EditValue = dok.Data;
                labelDataOdbioru.EditValue = pars.DataOdbioru;


                // labelNazwaFirmy2.EditValue = pieczatka.Nazwa;
                // labelAdresSiedziby3.EditValue = pieczatka.Adres.Linia1;
                // labelAdresSiedziby4.EditValue = pieczatka.Adres.Linia2;
            }
            
            void Grid_BeforeRow(Object sender, RowEventArgs args)
            {
                PozycjaDokHandlowego poz = (PozycjaDokHandlowego)args.Row;
                if (pars.Jednostka == JednostkaKg.kg1)
                {
                    gridColumnJm.EditValue = "kg";
                    gridColumntIlosc.EditValue = poz.Ilosc.Value*1000;
                }
                else
                {
                    gridColumnJm.EditValue = "1000 kg";
                    gridColumntIlosc.EditValue = poz.Ilosc.Value;
                }

                gridColumnPodstawa.EditValue = pars.PodstawaZwolnienia;
                gridColumnCN.EditValue = poz.KodCN; 
            }

        </script>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR"/>
        <meta content="C#" name="CODE_LANGUAGE"/>
        <meta content="JavaScript" name="vs_defaultClientScript"/>
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema"/>
    </head>
<body>
    <form id="Sprzedaż" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnContextLoad="OnContextLoad" Landscape="True"></ea:DataContext>
        
        <ea:DataRepeater runat="server" ID="DataRepeater1">
    <ea:PageBreak runat="server" BreakFirstTimes="false"></ea:PageBreak>

    <table style="width:100%; font-family:Tahoma; font-size:8pt; border-collapse: collapse; " >
        <tr>
        <td style="width: 75%; border-style: solid solid solid none; border-color: Silver; border-width: 1px; text-align: center; background-color: Gray;">
            <b>DOKUMENT DOSTAWY</b><br />
            <i>/Delivery document/</i>
        </td>
        <td style="width: 25%; border-style: solid solid solid none; border-color: Silver; border-width: 1px; text-align: center;">
            <b>NR</b><i>/NO/</i><br /><ea:DataLabel runat="server" DataMember="Numer.Pelny"></ea:DataLabel> 
        </td>
      </tr>
    </table>
            
            


    <table style="width:100%; font-family:Tahoma; font-size:8pt; border-collapse: collapse;  " >
        
        <!-- I -->

        <tr>
            <td style="border-style: none solid solid solid; width:50%; border-color:Silver; border-width:1px; vertical-align:top; ">
                <table style="width:100%; font-family:Tahoma; font-size:8pt; margin: 0px; border-collapse: collapse;   ">
                    <tr>
                        <td colspan="2" style="">
                            1. Nazwa/nazwisko i imię podmiotu, który wystawił dokument dostawy:<br />
                             <i>/Name/surname of the document drawer/</i>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 75px; vertical-align: top; ">
                            <ea:DataLabel runat="server" ID="labelNazwaFirmy"></ea:DataLabel>
                        </td>
                        <td style="width: 25px; border-bottom-width: 0px; border-right-width: 0px; border-top: silver solid 1px; border-left: silver solid 1px;">
                            Nr akcyzowy podmiotu<br />
                            <i>/Entity's excise duty identification number/</i>
                            <br />
                            <br />
                            <ea:DataLabel runat="server" ID="labelNrAkcyzowy"></ea:DataLabel>
                        </td>
                    </tr>
                </table>
            </td>
            <td style="border-style: none solid solid none; border-color:Silver; border-width:1px; vertical-align:top;">
                <table style="width:100%; font-family:Tahoma; font-size:8pt; margin: 0px; border-collapse: collapse;   ">
                    <tr>
                        <td colspan="2" style="">
                            3. Podmiot odbierający/zwracający:<br />
                            <i>/Consignee/entity returning exempted goods/</i>
                            <br />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 75px; vertical-align: top; ">
                            <ea:DataLabel runat="server" ID="labelKontrahent" DataMember="Kontrahent.Nazwa"></ea:DataLabel>
                        </td>
                        <td style="width: 25px; border-bottom-width: 0px; border-right-width: 0px; border-top: silver solid 1px; border-left: silver solid 1px;">
                            Nr akcyzowy podmiotu<br />
                            <i>/Entity's excise duty identification number/</i>
                            <br />
                            <br />
                            <ea:DataLabel runat="server" ID="labelNrAkcyzowyPodmiotu"></ea:DataLabel>
                        </td>
                    </tr>
                </table>
            </td>
      </tr>
        
      <!-- II -->
        
      <tr>
            <td style="border-style: none solid solid solid; border-color:Silver; border-width:1px; vertical-align:top;">
                2.  Adres siedziby/miejsca zamieszkania podmiotu, który wystawił dokument dostawy:<br />
                <i>/Drawer's address/place of residence/</i>
                <br />
                <br />
                <ea:DataLabel runat="server" ID="labelAdresSiedziby1"></ea:DataLabel>
                <ea:DataLabel runat="server" ID="labelAdresSiedziby2"></ea:DataLabel>
            </td>    
            <td style="border-style: none solid solid none; border-color:Silver; border-width:1px; vertical-align:top;">
                4. Adres siedziby/miejsca zamieszkania podmiotu odbierającego/zwracającego:<br />
                <i>/Consignee's/entity’s returning exempted goods address/place of residence/</i>
                <br />
                <br />
                <ea:DataLabel runat="server" ID="DataLabel2" DataMember="DaneKontrahenta.Adres.Linia1"></ea:DataLabel>
                <ea:DataLabel runat="server" ID="DataLabel3" DataMember="DaneKontrahenta.Adres.Linia2"></ea:DataLabel>
            </td>    
      </tr>

      <!-- III -->

      <tr>
            <td style="border-style: none solid solid solid; border-color:Silver; border-width:1px; vertical-align:top;">
                5. Adres miejsca wysyłki wyrobów zwolnionych:<br />
                <i>/Address of dispatch place/</i>
                <br />
                <br />
                <ea:DataLabel runat="server" ID="labelAdresWysylki"></ea:DataLabel><br />
            </td>
            <td style="border-style: none solid solid none; border-color:Silver; border-width:1px; vertical-align:top;">
                7. Miejsce odbioru wyrobów zwolnionych:<br />
                <i>/Address of place of receipt/</i>
                <br />
                <br />
                <ea:DataLabel runat="server" ID="labelAdresOdbioru"></ea:DataLabel><br />
          </td>
      </tr>                  

        <!-- IV -->

      <tr>
            <td style="border-style: none solid solid solid; border-color:Silver; border-width:1px; vertical-align:top;">
                6. Data wysyłki wyrobów zwolnionych <i>/Date of dispatch of exempted goods/</i> :
                <br />
                <br />
                <ea:DataLabel runat="server" ID="labelDataWysylki" ></ea:DataLabel>
            </td>
            <td style="border-style: none solid solid none; border-color:Silver; border-width:1px; vertical-align:top;">
                8. Data odbioru wyrobów zwolnionych <i>/Date of receipt of exempted goods/</i> :
                <br />
                <br />
                <ea:DataLabel runat="server" ID="labelDataOdbioru" ></ea:DataLabel>
            </td>
      </tr>                  

        <!-- V -->


      <tr>
        <td style="border-style: none solid solid solid; border-color:Silver; border-width:1px; vertical-align:top;">
            9. Data i podpis podmiotu, który wystawił dokument dostawy, lub osoby reprezentującej ten podmiot:
            <br />
            <i>/Date and drawer's or his representative signature/</i>
            <p style="text-align:center;">
                <br />
                <br />
                ...............................................................................................................
                <br />
            </p>
        </td>
        <td style="border-style: none solid solid solid; border-color:Silver; border-width:1px; vertical-align:top;">
            10. Potwierdzam odbiór/zwrot wyrobów wymienionych w polu 11
            <br />
            <i>/I confirm receipt/return of goods mentioned in section 11/</i>       
            <p style="text-align:center;">
                <br />
                ...............................................................................................................
                <br />
            </p>
            <p style="text-align: center; ">
                Data i podpis podmiotu odbierającego/zwracającego  lub osoby reprezentującej podmiot odbierający/zwracający
                <br /> 
                <i>/Date and signature of entity which receipt/return goods or his representative/</i>
            </p>
        </td>
      </tr>                  

    </table>
            
    <br />

    <table style="width:100%; font-family:Tahoma; font-size:8pt; border-collapse: collapse;">
      <tr>
        <td style="border-style: solid; border-color:Silver; border-width:1px; text-align:center; background-color:Gray;"><b>11. WYROBY AKCYZOWE ZWOLNIONE OD AKCYZY STANOWIĄCE PRZEDMIOT DOSTAWY</b></td>
      </tr>
    </table>
            
	<ea:Grid runat="server" ID="grid1" DataMember="Pozycje" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" OnBeforeRow="Grid_BeforeRow" >
		<Columns>
			<ea:GridColumn Width="5" Align="Right" DataMember="Lp" Caption="L.p."></ea:GridColumn>
			<ea:GridColumn  Align="Left" DataMember="Towar" Caption="Nazwa wyrobu"></ea:GridColumn>
			<ea:GridColumn Width="15" Align="Center" ID="gridColumnCN" Caption="Kod CN wyrobu"></ea:GridColumn>
			<ea:GridColumn Width="15" Align="Center" ID="gridColumnJm" Caption="Jm."></ea:GridColumn>
			<ea:GridColumn Width="15" Align="Right" ID="gridColumntIlosc" Caption="Ilość w j.m."></ea:GridColumn>
			<ea:GridColumn Width="35" Align="Left" ID="gridColumnPodstawa" Caption="Przeznaczenie uprawniające do zwolnienia (krótki opis i podstwa prawna)"></ea:GridColumn>
			<ea:GridColumn Width="35" Align="Left" Caption="Adnotacje dotyczące odbioru wyrobów"></ea:GridColumn>
		</Columns>
	</ea:Grid>
</ea:DataRepeater>	

    </form>
</body>
</html>
